unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls,
  {  }
  UKlasy,
  USilnik;

const cSIZE : Byte = 30;


type
  TForm1 = class(TForm)
    Timer1: TTimer;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel4: TPanel;
    Panel3: TPanel;
    procedure FormPaint(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);

  private
	 engine : Silnik;

  public

  end;

var
  Form1: TForm1;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
var
	fig       : Figura;
   x1        : Integer;
   y1        : Integer;
   x2        : Integer;
   y2        : Integer;
   lp        : Integer;
   gora      : Boolean;
   lewo      : Boolean;
   skok      : Integer;
   tabKolory : array of TColor;

begin
	SetLength(tabKolory, 14);

   tabKolory[0]  := clAqua;
   tabKolory[1]  := clRed;
   tabKolory[2]  := clTeal;
   tabKolory[3]  := clCream;
   tabKolory[4]  := clSilver;
   tabKolory[5]  := clFuchsia;
   tabKolory[6]  := clSkyBlue;
   tabKolory[7]  := clWhite;
   tabKolory[8]  := clInfoBk;
   tabKolory[9]  := clLtGray;
   tabKolory[10] := clBtnShadow;
   tabKolory[11] := clMedGray;
   tabKolory[12] := clMoneyGreen;
   tabKolory[13] := clYellow;

   x1        := 0;
   y1        := 0;
   x2        := 0;
   y2        := 0;
   lp        := 0;
   gora      := false;
   lewo      := true;
   skok      := 0;

	engine    := Silnik.Create();

   x1 := 40; y1 := 40; x2 := x1 + cSIZE; y2 := y1 + cSIZE;

	for lp := 0 to Length(tabKolory)-1 do
   begin
      // warto o jak ma si przemieszcza figura ustalana losowo
		// skok := random(14); // zmniejszajc liczb zwalniamy ruch
		skok := random(5);
      // ale nie zero
      if (skok = 0) then
      begin
      	skok := 5;
      end;

      fig := Figura.Create(Form1.Canvas,         // wskanik do Canvas
                           IntToStr(lp),         // etykieta figury
                           x1, y1, x2, y2,       // wsprzdne dla figury
                           not gora,             // w gr
                           not lewo,             // w lewo
                           skok,                 // skok
                           clBlack,              // Pen color
                           tabKolory[lp],        // Brush color
                           Screen.Width,         // szeroko
                           Screen.Height);       // wysoko

      engine.Add(fig);

      x1 := x1 + 20;
      y1 := y2 + 10;
      x2 := x1 + cSIZE;
      y2 := y1 + cSIZE;
   end;


	WindowState := wsNormal;
	Height      := Screen.Height;
   Width       := Screen.Width;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	if Assigned(engine) then
   begin
   	FreeAndNil(engine);
   end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
	Form1.Invalidate();
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
	if Assigned(engine) then
   begin
		engine.Move();
   end;
end;

end.
